"use strict";
//
// Copyright 2023 Signal Messenger, LLC.
// SPDX-License-Identifier: AGPL-3.0-only
//
Object.defineProperty(exports, "__esModule", { value: true });
const crypto_1 = require("crypto");
const ByteArray_1 = require("../internal/ByteArray");
const Constants_1 = require("../internal/Constants");
const Native = require("../../../Native");
const CreateCallLinkCredentialResponse_1 = require("./CreateCallLinkCredentialResponse");
class CreateCallLinkCredentialRequest extends ByteArray_1.default {
    constructor(contents) {
        super(contents, Native.CreateCallLinkCredentialRequest_CheckValidContents);
    }
    issueCredential(userId, timestamp, params) {
        const random = (0, crypto_1.randomBytes)(Constants_1.RANDOM_LENGTH);
        return this.issueCredentialWithRandom(userId, timestamp, params, random);
    }
    issueCredentialWithRandom(userId, timestamp, params, random) {
        return new CreateCallLinkCredentialResponse_1.default(Native.CreateCallLinkCredentialRequest_IssueDeterministic(this.contents, userId.getServiceIdFixedWidthBinary(), timestamp, params.contents, random));
    }
}
exports.default = CreateCallLinkCredentialRequest;
//# sourceMappingURL=CreateCallLinkCredentialRequest.js.map